/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard.exe;

import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.builder.preferences.DependenciesManager;
import com.aptana.editor.php.internal.builder.preferences.PHPExtension;
import com.aptana.php.debug.ui.phpini.Messages;
import com.aptana.ui.util.SWTUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.internal.debug.ui.wizard.TextDialogCellEditor;

public class PHPExtensionsEditor {
    private static final String NAME_PROPERTY = Messages.PHPIniEditor_3;
    private static final String VALUE_PROPERTY = Messages.PHPIniEditor_4;
    private Composite mainComposite;
    private Button addEntryButton;
    private Button removeButton;
    private CheckboxTableViewer viewer;

    public Control createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        Control buttonsContainer = this.createButtonsBar(this.mainComposite);
        GridData buttonsContainerData = new GridData(768);
        buttonsContainer.setLayoutData((Object)buttonsContainerData);
        Control viewerContainer = this.createViewer(this.mainComposite);
        GridData viewerContainerData = new GridData(1808);
        viewerContainerData.grabExcessHorizontalSpace = true;
        viewerContainerData.grabExcessVerticalSpace = true;
        viewerContainer.setLayoutData((Object)viewerContainerData);
        this.modifyButtonsStates();
        this.disable();
        return this.mainComposite;
    }

    private void modifyButtonsStates() {
        if (this.viewer.getSelection().isEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    private void disable() {
    }

    private Control createViewer(Composite parent) {
        Composite viewerContainer = new Composite(parent, 0);
        viewerContainer.setLayout((Layout)new FillLayout());
        this.viewer = new CheckboxTableViewer(new Table(viewerContainer, 67616));
        this.viewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY});
        this.viewer.setLabelProvider((IBaseLabelProvider)new PHPExtensionLabelProvider());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event arg0) {
                Object data = arg0.widget.getData("H");
                if (data == null) {
                    arg0.widget.setData("H", (Object)this);
                    arg0.height += 2;
                }
            }
        });
        TableColumn nameColumn = new TableColumn(this.viewer.getTable(), 0);
        nameColumn.setText(Messages.PHPExtensionsEditor_NAME);
        TableColumn valueColumn = new TableColumn(this.viewer.getTable(), 0);
        valueColumn.setText(Messages.PHPExtensionsEditor_PATH);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.viewer.getTable());
        this.viewer.setCellEditors(new CellEditor[]{valueEditor, new TextDialogCellEditor((Composite)this.viewer.getTable()){

            @Override
            protected Object openDialogBox(Control cellEditorWindow) {
                return new FileDialog(cellEditorWindow.getShell(), 4096).open();
            }
        }});
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                PHPExtension ext = (PHPExtension)element;
                if (property.equals(NAME_PROPERTY)) {
                    return ext.getName();
                }
                if (property.equals(VALUE_PROPERTY)) {
                    return ext.getPath();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                PHPExtension ext = (PHPExtension)((TableItem)element).getData();
                if (property.equals(NAME_PROPERTY)) {
                    ext.setName(value.toString());
                } else if (property.equals(VALUE_PROPERTY)) {
                    ext.setPath(value.toString());
                }
                PHPExtensionsEditor.this.viewer.refresh((Object)ext);
                PHPExtensionsEditor.this.store();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PHPExtensionsEditor.this.modifyButtonsStates();
            }
        });
        this.viewer.getTable().setLayout((Layout)tableLayout);
        this.viewer.getTable().getParent().layout(true, true);
        List extensions = DependenciesManager.getExtensions();
        for (PHPExtension e : extensions) {
            this.viewer.add((Object)e);
        }
        return viewerContainer;
    }

    void store() {
        ArrayList<PHPExtension> exts = new ArrayList<PHPExtension>();
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem e = tableItemArray[n2];
            exts.add((PHPExtension)e.getData());
            ++n2;
        }
        DependenciesManager.setExtensions(exts);
    }

    private Control createButtonsBar(Composite mainComposite2) {
        Composite buttonsComposite = new Composite(this.mainComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        this.addEntryButton = new Button(buttonsComposite, 0);
        this.addEntryButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addEntryButton.setToolTipText(Messages.PHPIniEditor_7);
        this.addEntryButton.setImage(SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/add.gif"));
        this.addEntryButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPExtensionsEditor.this.addEntry();
                PHPExtensionsEditor.this.store();
            }
        });
        this.removeButton = new Button(buttonsComposite, 0);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeButton.setToolTipText(Messages.PHPIniEditor_8);
        this.removeButton.setImage(SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/delete.gif"));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPExtensionsEditor.this.removeEntry();
                PHPExtensionsEditor.this.store();
            }
        });
        return buttonsComposite;
    }

    protected void removeEntry() {
        this.viewer.remove(((StructuredSelection)this.viewer.getSelection()).toArray());
    }

    protected void addEntry() {
        FileDialog ll = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        String open = ll.open();
        if (open != null) {
            PHPExtension extension = new PHPExtension(open);
            this.viewer.add((Object)extension);
            this.viewer.setChecked((Object)extension, true);
        }
    }

    static class PHPExtensionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PHPExtensionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PHPExtension ext = (PHPExtension)element;
            if (columnIndex == 0) {
                return ext.getName();
            }
            if (columnIndex == 1) {
                return ext.getPath();
            }
            return null;
        }
    }
}

